/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.stream;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.FcsConnectionManager;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryCenter;
import com.ibm.hwmca.fw.fcs.impl.stream.StreamConstants;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FcsControlService
implements FcsService,
StreamConstants {
    private static final String TRACE_MASKD = "XFCSFCSD";
    private static final String TRACE_MASKF = "XFCSFCSF";
    private static final String TRACE_MASKT = "XFCSFCST";
    private FcsConnection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processConnection(FcsConnection connection) {
        this.connection = connection;
        try {
            connection.getSocket().setSoTimeout(120000);
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(connection.getSocket().getInputStream()));
            Map inMap = (Map)ois.readObject();
            Map outMap = this.buildResponse(inMap);
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(connection.getSocket().getOutputStream()));
            oos.flush();
            oos.writeObject(outMap);
            oos.flush();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            this.handleError(t);
        }
        finally {
            try {
                connection.getSocket().close();
            }
            catch (Exception e) {}
        }
    }

    private Map buildResponse(Map inMap) {
        String command = (String)inMap.get("FcsControlCommand");
        if (command == null) {
            command = "";
        }
        if (command.equals("FcsControlCommandPing")) {
            return this.handlePing(inMap);
        }
        if (command.equals("FcsControlCommandDataExchange")) {
            return this.handleDataExchange(inMap);
        }
        if (command.equals("FcsControlCommandHorizon")) {
            return this.handleHorizonSearch(inMap);
        }
        Trace.trace(TRACE_MASKF, "I didn't understand command: " + command);
        return new HashMap();
    }

    private Map handlePing(Map inMap) {
        Trace.trace(TRACE_MASKT, "FcsControlService.handlePing()");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FcsControlCommand", "FcsControlCommandPong");
        return map;
    }

    private Map handleDataExchange(Map inMap) {
        Trace.trace(TRACE_MASKT, "<> FcsControlService.handleDataExchange()");
        MachineId machineId = (MachineId)inMap.get("FcsControlMachineId");
        Set services = (Set)inMap.get("FcsControlServices");
        Date bootTime = (Date)inMap.get("FcsControlBootTime");
        if (machineId != null && services != null && bootTime != null) {
            FcsServer.getFcsServer().addRemoteServiceList(machineId, services, bootTime);
            FcsConnectionManager.didHandshake(machineId);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FcsControlCommand", "FcsControlCommandDataExchange");
        map.put("FcsControlMachineId", FcsServer.getFcsServer().getLocalMachineId());
        map.put("FcsControlServices", FcsServer.getFcsServer().getLocalServices());
        map.put("FcsControlBootTime", FcsServer.getFcsServer().getLocalBootTime());
        return map;
    }

    private Map handleHorizonSearch(Map inMap) {
        Trace.trace(TRACE_MASKT, "<> FcsControlService.handleHorizonSearch()");
        Set otherMachines = (Set)inMap.get("FcsControlCommandHorizon");
        Set currentList = FcsServer.getFcsServer().getMachineList();
        Iterator iterator = otherMachines.iterator();
        while (iterator.hasNext()) {
            MachineId nextId = (MachineId)iterator.next();
            DiscoveryCenter.getDiscoveryCenter().foundAddresses(nextId.getNicAddresses(), DiscoveryCenter.fcsInternallyDiscovered);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FcsControlCommand", "FcsControlCommandHorizon");
        map.put("FcsControlCommandHorizon", currentList);
        return map;
    }

    private void handleError(Throwable t) {
    }
}

